<?php

if (!defined('ABSPATH'))
    exit;

class fhpc_core {

    /**
     * The single instance
     * @var 	object
     * @access  private
     * @since 	1.0.0
     */
    private static $_instance = null;

    /**
     * Settings class object
     * @var     object
     * @access  public
     * @since   1.0.0
     */
    public $settings = null;

    /**
     * The version number.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $_version;

    /**
     * The token.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $_token;

    /**
     * The main plugin file.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $file;

    /**
     * The main plugin directory.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $dir;

    /**
     * The plugin assets directory.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $assets_dir;

    /**
     * The plugin assets URL.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $assets_url;

    /**
     * Suffix for Javascripts.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $templates_url;

    /**
     * Suffix for Javascripts.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $script_suffix;

    /**
     * For menu instance
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $menu;

    /**
     * For template
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $plugin_slug;

    /**
     * Constructor function.
     * @access  public
     * @since   1.0.0
     * @return  void
     */
    public function __construct($file = '', $version = '1.2.0') {
        $this->_version = $version;
        $this->_token = 'fhpc';
        $this->plugin_slug = 'fhpc';
        $this->file = $file;
        $this->dir = dirname($this->file);
        $this->assets_dir = trailingslashit($this->dir) . 'assets';
        $this->assets_url = esc_url(trailingslashit(plugins_url('/assets/', $this->file)));
        $this->templates_url = esc_url(trailingslashit(plugins_url('/templates/', $this->file)));
        $this->chmodWrite = ( 0747 & ~ umask() );
        if (defined('FS_CHMOD_DIR')) {
            $this->chmodWrite = FS_CHMOD_DIR;
        }
        if ($this->chmodWrite == 0745) {
            $this->chmodWrite = 0755;
        }
        $this->templates = array('helper_template.php' => esc_html__('Helper template', $this->plugin_slug));
        add_action('wp_enqueue_scripts', array($this, 'frontend_enqueue_scripts'), 10, 1);
        add_action('wp_enqueue_scripts', array($this, 'frontend_enqueue_styles'), 10, 1);
        add_action('admin_enqueue_scripts', array($this, 'admin_enqueue_scripts'), 10, 1);
        add_action('admin_enqueue_scripts', array($this, 'frontend_enqueue_styles'), 10, 1);
        add_action('plugins_loaded', array($this, 'init_localization'));
    }

    /*
     * Plugin init localization
     */

    public function init_localization() {
        $moFiles = scandir(trailingslashit($this->dir) . 'languages/');
        foreach ($moFiles as $moFile) {
            if (strlen($moFile) > 3 && substr($moFile, -3) == '.mo' && strpos($moFile, get_locale()) > -1) {
                load_textdomain('fhpc', trailingslashit($this->dir) . 'languages/' . $moFile);
            }
        }
    }

    /**
     * Load frontend CSS.
     * @access  public
     * @since   1.0.0
     * @return void
     */
    public function frontend_enqueue_styles($hook = '') {
        wp_register_style($this->_token . '_frontend', esc_url($this->assets_url) . 'css/fhpc_frontend.min.css', array(), $this->_version);
        wp_enqueue_style($this->_token . '_frontend');
        wp_register_style($this->_token . '_colors', esc_url($this->assets_url) . 'css/fhpc_customCss.css', array(), $this->_version);
        wp_enqueue_style($this->_token . '_colors');
    }

    /**
     * Load admin Javascript.
     * @access  public
     * @since   1.0.0
     * @return void
     */
    public function admin_enqueue_scripts($hook = '') {
        global $wpdb;
        global $post;
        $post_id = '';
        if ($post) {
            $post_id = $post->ID;
        }
        if (!function_exists('is_plugin_active')) {
            include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        }
        wp_register_script($this->_token . '_frontend', esc_url($this->assets_url) . 'js/fhpc_frontend.min.js', array('jquery',
            'jquery-ui-core',
            'jquery-ui-mouse',
            'jquery-ui-position',
            'jquery-ui-droppable',
            'jquery-ui-draggable',
            'jquery-ui-resizable',
            'jquery-effects-core',
            'jquery-effects-drop',
            'jquery-effects-fade',
            'jquery-effects-bounce'), $this->_version);
        wp_enqueue_script($this->_token . '_frontend');

        $validHelpers = array();
        $helpers = array();
        $table_name = $wpdb->prefix . "fhpc_steps";
        $helpers = $wpdb->get_results('SELECT * FROM ' . $table_name . ' ORDER BY ordersort');
        foreach ($helpers as $helper) {
            $table_name = $wpdb->prefix . "fhpc_items";
            $helper->items = $wpdb->get_results('SELECT * FROM ' . $table_name . ' WHERE stepID=' . $helper->id . ' ORDER BY ordersort');
            foreach ($helper->items as $item) {
                $item->content = do_shortcode($item->content);
            }
            if ($helper->rolesAllowed != "") {
                $rolesAllowed = explode(',', $helper->rolesAllowed);
                if (is_user_logged_in()) {
                    $user = new WP_User(get_current_user_id());
                    $chkOK = false;
                    if (!empty($user->roles) && is_array($user->roles)) {
                        foreach ($user->roles as $role) {
                            if ($role == "shop_manager") {
                                $role = "shop-manager";
                            }
                            if (in_array($role, $rolesAllowed)) {
                                $chkOK = true;
                            }
                        }
                    }
                    if ($chkOK) {
                        $validHelpers[] = $helper;
                    }
                }
            } else {
                $validHelpers[] = $helper;
            }
        }

        $username = '';
        if ((is_plugin_active('buddypress/bp-loader.php')) && is_user_logged_in()) {
            $username = urlencode(bp_get_displayed_user_username());
        } if($username == '' && is_user_logged_in()) {
            $userWP = wp_get_current_user();
            $username = $userWP->display_name;
        }

       $profileUrl = '';
        
         if ((is_plugin_active('buddypress/bp-loader.php')) && is_user_logged_in()) {
           $username = bp_core_get_username(bp_loggedin_user_id());
            $profileUrl = urlencode(bp_core_get_user_domain(bp_loggedin_user_id()));            
        } else if(is_user_logged_in()){
			 $profileUrl = get_author_posts_url(get_current_user_id() );
		 }
        
        
        wp_localize_script($this->_token . '_frontend', 'fhpc_data', array(
            'tours'=>$validHelpers,
            'siteurl'=>site_url() . '/',
            'profileUrl' => $profileUrl,
            'username' => $username,
            'postID' => $post_id
        ));
        
    }


    /**
     * Return settings.
     * @access  public
     * @since   1.0.0
     * @return  void
     */
    public function getSettings() {
        global $wpdb;
        $table_name = $wpdb->prefix . "fhpc_settings";
        $settings = $wpdb->get_results("SELECT * FROM $table_name WHERE id=1 LIMIT 1");
        if (count($settings) > 0) {
            return $settings[0];
        } else {
            return false;
        }
    }

    /**
     * Load frontend Javascript.
     * @access  public
     * @since   1.0.0
     * @return void
     */
    public function frontend_enqueue_scripts($hook = '') {
        global $wpdb;
        global $post;
        $post_id = '';
        if ($post) {
            $post_id = $post->ID;
        }
        wp_register_script($this->_token . '-frontend', esc_url($this->assets_url) . 'js/fhpc_frontend.min.js', array('jquery',
            'jquery-ui-core',
            'jquery-ui-mouse',
            'jquery-ui-position',
            'jquery-ui-droppable',
            'jquery-ui-draggable',
            'jquery-ui-resizable',
            'jquery-effects-core',
            'jquery-effects-drop',
            'jquery-effects-fade',
            'jquery-effects-bounce'), $this->_version);
        wp_enqueue_script($this->_token . '-frontend');

        $helpers = array();
        $validHelpers = array();
        $table_name = $wpdb->prefix . "fhpc_steps";
        $helpers = $wpdb->get_results('SELECT * FROM ' . $table_name . ' ORDER BY ordersort');
        foreach ($helpers as $helper) {
            $table_name = $wpdb->prefix . "fhpc_items";
            $helper->items = $wpdb->get_results('SELECT * FROM ' . $table_name . ' WHERE stepID=' . $helper->id . ' ORDER BY ordersort');
            foreach ($helper->items as $item) {
                $item->content = do_shortcode($item->content);
            }
            if ($helper->rolesAllowed != "") {
                $rolesAllowed = explode(',', $helper->rolesAllowed);
                if (is_user_logged_in()) {
                    $user = new WP_User(get_current_user_id());
                    $chkOK = false;
                    if (!empty($user->roles) && is_array($user->roles)) {
                        foreach ($user->roles as $role) {
                            if (in_array($role, $rolesAllowed)) {
                                $chkOK = true;
                            }
                        }
                    }
                    if ($chkOK) {
                        $validHelpers[] = $helper;
                    }
                }
            } else {
                $validHelpers[] = $helper;
            }
        }
        $settings = $this->getSettings();
        $username = '';
        
        if (!function_exists('is_plugin_active')) {
            include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        }
        if (is_plugin_active('buddypress/bp-loader.php') && is_user_logged_in()) {
            $username = urlencode(bp_get_displayed_user_username());
        }
        if($username == '' && is_user_logged_in()) {
            $userWP = wp_get_current_user();
            $username = $userWP->display_name;
        }
        $profileUrl = '';
        
         if ((is_plugin_active('buddypress/bp-loader.php')) && is_user_logged_in()) {
           $username = bp_core_get_username(bp_loggedin_user_id());
            $profileUrl = urlencode(bp_core_get_user_domain(bp_loggedin_user_id()));            
        } else if(is_user_logged_in()){
			 $profileUrl = get_author_posts_url(get_current_user_id() );
		 }
        
        wp_localize_script($this->_token . '-frontend', 'fhpc_data', array(
            'tours'=>$validHelpers,
            'siteurl'=>site_url() . '/',
            'profileUrl' => $profileUrl,
            'username' => $username,
            'postID' => $post_id
        ));
    }

    /**
     * Load popup template.
     * @access  public
     * @since   1.0.0
     * @return void
     */
    public function load_template($template) {
        $file = plugin_dir_path(__FILE__) . '../templates/helper_template.php';
        if (file_exists($file)) {
            return $file;
        }
    }

    /**
     * Initialise helpers
     * @access  private
     * @since   1.0.0
     * @return void
     */
    private function init_helpers() {
        
    }

    /**
     * Main WPE_Tools Instance
     *
     *
     * @since 1.0.0
     * @static
     * @see WPE_Tools()
     * @return Main WPE_Tools instance
     */
    public static function instance($file = '', $version = '1.0.0') {
        if (is_null(self::$_instance)) {
            self::$_instance = new self($file, $version);
        }
        return self::$_instance;
    }

// End instance()

    /**
     * Cloning is forbidden.
     *
     * @since 1.0.0
     */
    public function __clone() {
        _doing_it_wrong(__FUNCTION__, esc_html__('Cheatin&#8217; huh?'), $this->_version);
    }

// End __clone()

    /**
     * Unserializing instances of this class is forbidden.
     *
     * @since 1.0.0
     */
    public function __wakeup() {
        _doing_it_wrong(__FUNCTION__, esc_html__('Cheatin&#8217; huh?'), $this->_version);
    }

// End __wakeup()

    /**
     * Log the plugin version number.
     * @access  public
     * @since   1.0.0
     * @return  void
     */
    private function _log_version_number() {
        update_option($this->_token . '_version', $this->_version);
    }

}
